/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.messaging.service.inbound;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.security.SecurityContextHelper;

import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.messaging.service.AbstractMessagingService;

/**
 * Initial javadoc for class AbstractInboundMessagingService. TODO - Add content
 * here
 * 
 * Created Feb 28, 2006 3:20:09 PM
 * 
 * @author DNS   BOHMEG
 */
public abstract class AbstractInboundMessagingService extends
		AbstractMessagingService implements InboundProcessService {
	public static final String INBOUND_MESSAGE_AUDIT_PREFIX = "VAMC-";
	
	protected void initAuditIdFromMessage(Message message)
			throws InvalidMessageException {
		String stationNumber = message.getSendingFacility();
		// depending on requirements, use the logical name of the site for audit
		// purposes
		SecurityContextHelper.getSecurityContext().setLogicalName(
				INBOUND_MESSAGE_AUDIT_PREFIX + stationNumber);
	}
	
}
