/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.constants;

/**
 * Only use this if there is no specific lookup class
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public interface HL7Constants {
		
	/////////////////////////////////
	// Message Type Constants
	/////////////////////////////////
    public static final String ORUZ04 = "ORUZ04";
    public static final String ORUZ05 = "ORUZ05"; 
    public static final String ORUZ06 = "ORUZ06";    
	public static final String ORUZ07 = "ORUZ07"; 
 	public static final String ORFZ10 = "ORFZ10";
	public static final String ORUZ10 = "ORUZ10";
	public static final String ORUZ11 = "ORUZ11";
	public static final String ORFZ11 = "ORFZ11";
	public static final String QRYZ07 = "QRYZ07";
	public static final String QRYZ10 = "QRYZ10";
	public static final String QRYZ11 = "QRYZ11";
	public static final String MFNZEG = "MFNZEG";
	public static final String ACK = "ACK";
	public static final String AE = "AE";
	public static final String AA = "AA";
	
	//MSDS Seeding Constants
	
	public static final String QUERY_Z21 = "Q21";
	public static final String RSPK21 = "RSPK21";
	public static final String QRYZ21 = "QBPQ21";
	
	public static final String UNSOLICITATED_MESSAGE = "ORU"; 
	public static final String SOLICITATED_MESSAGE = "ORF"; 
	public static final String QRY_MESSAGE = "QRY";
	
	/////////////////////////////////
	// JMS Message Property Constants
	//////////////////////////////////
	public static final String MESSAGE_ID = "Message_Id";
	public static final String MESSAGE_TYPE = "Message_Type";
	public static final String SENDING_APPLICATION = "Sending_Application";
	public static final String SENDING_SITE = "Sending_Site";
	public static final String RECEIVING_APPLICATION = "Receiving_Application";
	public static final String RECEIVING_SITE = "Receiving_Site";
	
	/////////////////////////////////
	// BHS MSH Segment Constants
	//////////////////////////////////
	public static final String HEADER_RECEIVING_APPLICATION_MVR = "MVR eGate";
	public static final String HEADER_RECEIVING_FACILITY_MVR = "MVR"; 	
	public static final String HEADER_SENDING_APPLICATION_MVR = "MVR"; 	
	
	public static final String HEADER_SENDING_APPLICATION = "ESR";  
	public static final String VERSION_ID = "2.3.1";
	public static final String ACCEPT_ACK_TYPE = "AL";
	public static final String APPLICATION_ACK_TYPE_AL ="AL";
	public static final String APPLICATION_ACK_TYPE_NE ="NE";
	public static final String HEADER_COUNTRY = "USA"; 
	public static final String NEW_VERSION_ID = "2.4";
	
	/////////////////////////////////
	// Query Message Constants
	//////////////////////////////////
	public static final String QUERY_FORMAT_CODE = "R";
	public static final String QUERY_PRIORITY = "I";
	public static final String QUANTITY_LIMITED_REQUEST = "1~RD";
	public static final String QUERY_RESULT_LEVEL = "T";
	public static final String WHAT_SUBJECT_FILTER_DEMOG = "DEM";
	public static final String WHAT_SUBJECT_FILTER_ELG = "ELG";
	public static final String WHAT_SUBJECT_FILTER_FIN = "FIN";
	public static final String WHAT_SUBJECT_FILTER_OTH = "OTH";
    public static final String WHERE_SUBJECT_FILTER_IVM = "IVM";
    public static final String WHAT_DEPARTMENT_DATA_CODE_ENROLLMENT = "ENROLLMENT";
    
    //Other Segment Constants
    //Spouse Set Id - 1st sequence in ZDP, ZIC, ZIR segments
    public static final String SPOUSE_SETID = "1";

}   

