/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.ZSP;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
 
/**
 * Class to build the ZSP segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ZSPBuilder extends AbstractSegmentBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 3136667414018458170L;



   /**
     * Default constructor.
     */
    public ZSPBuilder()
    {
        super();
    }

     /**
     * Method to build the ZSP segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZSP segment.
     * @return The ZSP segment.
     */
    public Object build(HL7MetaData metaData, SiteIdentity siteIdentity)
            throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }
        ZSP segment = new ZSP();
        setDefaultValues(segment);
        
        segment.setSetID("1");

        Person person = (Person) metaData.getEntity();

        try
        {
            //Set segment attributes            	
            ServiceConnectionAward scAward = person.getServiceConnectionAward();
            
            //If no SC award(vet or non vet), set SC Indicator to NO.
            //If contains SC award, use the ServiceConnectedIndicator
            if(scAward == null)
            {
                segment.setServiceConnected("0");
            }
            
            //Always populate the Service Period for vet and non vet
            segment.setServicePeriod(super.build(
                    getHelperService().getCurrentServicePeriod(person.getMilitaryService())));
            
            
            if (scAward != null)
            {
                segment.setServiceConnected(buildBooleanForVA001(scAward
                        .getServiceConnectedIndicator()));

                segment.setServiceConnectedPercentage((scAward
                        .getServiceConnectedPercentage() != null) ? scAward
                        .getServiceConnectedPercentage().toString() : null);

                segment.setPermanentAndTotal(buildBooleanForVA001(scAward
                        .isPermanentAndTotal()));

                segment.setUnemployable(buildBooleanForVA001(scAward
                        .isUnemployable()));
                
                segment.setServiceConnectedAwardDate(DateFormatter
                        .formatDate(scAward.getAwardDate()));

                segment
                        .setPermanentAndTotalEffectiveDate(DateFormatter
                                .formatDate(scAward
                                        .getPermanentAndTotalEffectiveDate()));
                segment
                        .setCombinedSCPercentEffectiveDate(DateFormatter
                                .formatDate(scAward
                                        .getCombinedServiceConnectedPercentageEffectiveDate()));
            }
            
            segment.setClassIIDentalIndicator(buildBooleanForVA001(person.getEligibleForClassIIDental()));
            segment.setClassIIDentalApplicationDueBeforeDate(DateFormatter
                    .formatDate(person
                            .getClassIIDentalApplicationDueBefore()));
            
        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build ZSP Segment due to an exception ", e);
        }

        return segment;
    }


    
    protected void setDefaultValues(Segment segment)
    {
        ZSP zsp = (ZSP)segment;
        
        zsp.setServiceConnected(SegmentConstants.DEFAULT_VALUE);
        zsp.setServiceConnectedPercentage(SegmentConstants.DEFAULT_VALUE);
        zsp.setServicePeriod(SegmentConstants.DEFAULT_VALUE);
        zsp.setPermanentAndTotal(SegmentConstants.DEFAULT_VALUE);
        zsp.setUnemployable(SegmentConstants.DEFAULT_VALUE);
        zsp.setServiceConnectedAwardDate(SegmentConstants.DEFAULT_VALUE);
        zsp.setPermanentAndTotalEffectiveDate(SegmentConstants.DEFAULT_VALUE);
        zsp.setCombinedSCPercentEffectiveDate(SegmentConstants.DEFAULT_VALUE);
        
    }
    

}