package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Builds the ZPD segment for Z05 message based on different
 * datatypes.
 * 
 * @author Rajiv Patnaik Created on Sep 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZPDZ05Builder extends AbstractZPDBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -7757898072700775107L;

   /**
     * Method to build the ZPD segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZPD segment.
     * @return The ZPD segment.
     */
    public Object build(HL7MetaData metaData, PersonTriggerEvent triggerEvent)
            throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person)
                || triggerEvent == null)
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        PersonTriggerIdentity personTriggerIdentity = (PersonTriggerIdentity) triggerEvent
                .getTriggerIdentity();
        PersonTrigger.DataType dataType = (PersonTrigger.DataType) personTriggerIdentity
                .getApplicableDataTypes().iterator().next();
        
        ZPD segment = new ZPD();
        segment.setSetID("1");

        Person person = (Person) metaData.getEntity();

        try
        {
        	//Sequence 6
        	if ( person.getFather() != null )
        	{
        		segment.setFatherName(ElementFormatter.formatName(person.getFather().getName()));
        	}

        	//Sequence 7
        	if ( person.getMother() != null )
        	{
        		segment.setMotherName(ElementFormatter.formatName(person.getMother().getName()));
        	}
        	

        	
            if (dataType == PersonTrigger.DataType.DATE_OF_DEATH)
            {        
                //Sequence 9, 31,32
                setDeathRecord(person, segment); //Sets death date and source.
            }else  if (dataType == PersonTrigger.DataType.GUARDIAN_INFO)
            {
                //Sequence 8
                setRatedIncompetent(person, segment); //Sets rated
            }
            
            
            
        	// Sequence 30
        	if ( person.getSpinalCordInjury() != null)
        	{
        		segment.setSpinalCordInjury(person.getSpinalCordInjury().getSpinalCordInjuryType().getCode());
        	}
        	// Sequence 34
        	if ( person.getPseudoSsn() != null)
        	{
        		segment.setSpinalCordInjury(person.getPseudoSsn().getPseudoSSNReason().getCode());
        	}
            
        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build ZPD Segment for Z05 due to an exception ", e);
        }

        return segment;
    }
}