package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Jan 5, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZMTMetaData extends HL7MetaData
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 6929222512122443468L;

   private MessageType messageType;
    
    //Needed for ORUZ10s and ORFZ10s
    private Integer incomeYear;
    private IncomeTest deletedIncomeTest;
    private SiteIdentity siteIdentity;
    
    //Needed for ORUZ06    
    private String action;
    private String type;
    
    
    public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	/**
     * @param entity
     */
    public ZMTMetaData(AbstractEntity entity, MessageType messageType)
    {
        super(entity);
        this.messageType = messageType;
    }

    /**
     * @return Returns the messageType.
     */
    public MessageType getMessageType()
    {
        return messageType;
    }
    
    
    /**
     * @return Returns the incomeYear.
     */
    public Integer getIncomeYear()
    {
        return incomeYear;
    }
    /**
     * @param incomeYear The incomeYear to set.
     */
    public void setIncomeYear(Integer incomeYear)
    {
        this.incomeYear = incomeYear;
    }

    /**
     * @return returns the deleted income test 
     */
    public IncomeTest getDeletedIncomeTest() {
        return deletedIncomeTest;
    }

    /**
     * @param deletedIncomeTest deleted income test
     */
    public void setDeletedIncomeTest(IncomeTest deletedIncomeTest) {
        this.deletedIncomeTest = deletedIncomeTest;
    }

	public SiteIdentity getSiteIdentity() {
		return siteIdentity;
	}

	public void setSiteIdentity(SiteIdentity siteIdentity) {
		this.siteIdentity = siteIdentity;
	} 
}
