/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZIV;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * Class to build the ZIV segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ZIVBuilder extends AbstractSegmentBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 5791566650622711691L;

   public ZIVBuilder()
    {
        super();
    }

    /**
     * Method to build the ZIV segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZIV segment.
     * @return The ZIV segment.
     */
    public Object build(HL7MetaData metaData, EntityKey entityKey)
            throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZIV segment = new ZIV();
        segment.setSetID("1");

        Person person = (Person) metaData.getEntity();
         
        InsurancePolicy matchingInsurancePolicy = person.getInsuranceByEntityKey(entityKey); 
        
        if (matchingInsurancePolicy != null)

            segment.setIvmID(matchingInsurancePolicy.getEntityKey().getKeyValueAsString());

        return segment;
    }
    
    /**
     * Method to build the ZIV segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZIV segment.
     * @return The ZIV segment.
     */
    public Object build(PersonTriggerEvent triggerEvent)
            throws BuilderException
    {
        if ((triggerEvent == null) )
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZIV segment = new ZIV();
        segment.setSetID("1");
        
        IncomeYearTriggerEvent incomeYearEvent = (IncomeYearTriggerEvent) triggerEvent;        
        
        segment.setIncomeYear(incomeYearEvent != null ? incomeYearEvent.getIncomeYear() > 0 ? incomeYearEvent.getIncomeYear().toString() + "0000": null : null);
        
        if(incomeYearEvent.getActionCode() != null ){
        	if(incomeYearEvent.getActionCode().equals("C") || incomeYearEvent.getActionCode().equals("R") ){
        		segment.setIvmCareStatus(incomeYearEvent.getActionCode().equals("C")? "1":"0");        		
        	}
        }
        

        

        return segment;
    }
}