package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;
/**
 * Class to hold data required to create a ZIR segment.
 * 
 * @author Rajiv Patnaik
 * Created on Jan 4, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZIRMetaData extends HL7MetaData
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -7093365632379421457L;

   private Integer incomeYear;
    
    private Relationship relationship;
    
    private RelationFinancials relationFinancials;    
    /**
     * The first sequence of the ZIR segment denoting if it is a spouse/dependent
     */
    private String setId;
     
    /**
     * @param entity
     */
    public ZIRMetaData(AbstractEntity entity, Integer incomeYear)
    {
        super(entity);
        this.incomeYear = incomeYear;
    }
    
    /**
     * @return Returns the relationFinancials.
     */
    public RelationFinancials getRelationFinancials()
    {
        return relationFinancials;
    }
    /**
     * @param relationFinancials The relationFinancials to set.
     */
    public void setRelationFinancials(RelationFinancials relationFinancials)
    {
        this.relationFinancials = relationFinancials;
    }
    
    /**
     * @return Returns the incomeYear.
     */
    public Integer getIncomeYear()
    {
        return incomeYear;
    }
    
    /**
     * @return Returns the relationship.
     */
    public Relationship getRelationship()
    {
        return relationship;
    }
    /**
     * @param relationship The relationship to set.
     */
    public void setRelationship(Relationship relationship)
    {
        this.relationship = relationship;
    }
    /**
     * @return Returns the setId.
     */
    public String getSetId()
    {
        return setId;
    }
    /**
     * @param setId The setId to set.
     */
    public void setSetId(String setId)
    {
        this.setId = setId;
    }
}
