package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * 
 * @author Rajiv Patnaik Created on Jan 6, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZIRDependentBuilder extends AbstractSegmentBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -395201802905318041L;


   /**
     * Method to build the ZIR segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZIR segment.
     * @return The ZIR segment.
     */
    public Object build(ZIRMetaData metaData) throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person)
                || metaData.getSetId() == null
                || metaData.getRelationship() == null)
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZIR segment = new ZIR();

        Relationship relationship = metaData.getRelationship();
        RelationFinancials relationFinancials = metaData
                .getRelationFinancials();

        //Seq 1
        segment.setSetID(metaData.getSetId());
        //For spouse seq 1 only

        if (relationFinancials != null)
        {
            //For dependents, 1,3,4,6-9, 14
            if (!Relationship.CODE_SPOUSE.getName().equals(
                    relationship.getCode()))
            {
                setDefaultValues(segment);
                
                DependentFinancials financials = (DependentFinancials) relationFinancials;
                
                //Seq 3
                segment
                        .setLivedWithPatient(super
                                .buildBooleanForVA001(financials
                                        .getLivedWithPatient()));
                //Seq 4
                segment.setAmountContributedToSpouseDep(super
                        .build(financials.getAmountContributedToSupport()));
                
                //Seq 6
                segment.setIncapableOfSelfSupport(super
                        .buildBooleanForVA001(financials
                                .getIncapableOfSelfSupport()));
                //Seq 7
                segment.setContributedToSupport(super
                        .buildBooleanForVA001(financials
                                .getContributedToSupport()));
                //Seq 8
                segment.setChildHadIncome(super.buildBooleanForVA001(financials
                        .getHasIncome()));
                //Seq 9
                segment.setIncomeAvailableToYou(super
                        .buildBooleanForVA001(financials
                                .getIncomeAvailableToPatient()));
                //Seq 14
                segment.setDependentChildSchoolIndicator(
                        super.buildBooleanFor0136(financials.getAttendedSchool()));

            }
        }
        return segment;
    }
    
    
    protected void setDefaultValues(Segment segment) 
    {
        ZIR zir = (ZIR) segment;
        zir.setLivedWithPatient(SegmentConstants.DEFAULT_VALUE);
        zir.setIncapableOfSelfSupport(SegmentConstants.DEFAULT_VALUE);
        zir.setContributedToSupport(SegmentConstants.DEFAULT_VALUE);
        zir.setChildHadIncome(SegmentConstants.DEFAULT_VALUE);
        zir.setIncomeAvailableToYou(SegmentConstants.DEFAULT_VALUE);
        zir.setNumberOfDependentChildren(SegmentConstants.DEFAULT_VALUE);
    }    
    
}