/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.util.builder.BuilderException;

//ESR Classes
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.*;
import gov.va.med.esr.service.FinancialsHelperService;

/**
 * Class to build the ZIR segment.
 * 
 * @author Alex Yoon
 * @author Rajiv Patnaik
 * @version 1.0
 */
public class ZIRBuilder extends AbstractSegmentBuilder
{
	
	private FinancialsHelperService financialsHelperService;
	
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -3840849286000062185L;

   public ZIRBuilder()
    {
        super();
    }
   
    public FinancialsHelperService getFinancialsHelperService() {
    	return financialsHelperService;
    }


	public void setFinancialsHelperService(
			FinancialsHelperService financialsHelperService) {
		this.financialsHelperService = financialsHelperService;
	}


	/**
     * Method to build the ZIR segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZIR segment.
     * @return The ZIR segment.
     */
    public Object build(ZIRMetaData metaData) throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person)
                || metaData.getIncomeYear() == null)
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZIR segment = new ZIR();
        segment.setSetID("1");
        setDefaultValues(segment);
        
        Person person = (Person) metaData.getEntity();
        Integer incomeYear = metaData.getIncomeYear();
        FinancialStatement financialStatement = person
                .getFinancialStatement(incomeYear);
        
        
        if(financialStatement != null)
        {
	        //Seq 2
	        segment.setMarriedLastCalendarYear(
	                buildBooleanForVA001(financialStatement.getMarriedLastCalendarYear()));
	
	        //The 'lived with patient' response is associated to the spouse's info 
	        SpouseFinancials spouseFinancials = financialsHelperService.getActiveSpouseFinancialsForVistaTransmission(person, incomeYear);
	        segment.setLivedWithPatient(spouseFinancials == null ? "" : super
	                .buildBooleanForVA001(spouseFinancials.getLivedWithPatient()));
	
	        //Seq 4
	        segment.setAmountContributedToSpouseDep(super.build(financialStatement.getContributionToSpouse()));
	        
            //Seq 15
            segment.setSpousalSupportIndicator(super
                  .buildBooleanForVA001(financialStatement.getContributedToSpouseInd()));
        }
        return segment;
    } 
    
    protected void setDefaultValues(Segment segment) 
    {
        ZIR zir = (ZIR) segment;
        zir.setMarriedLastCalendarYear(SegmentConstants.DEFAULT_VALUE);
        zir.setLivedWithPatient(SegmentConstants.DEFAULT_VALUE);
        zir.setAmountContributedToSpouseDep(SegmentConstants.DEFAULT_VALUE);
    }
}