/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZIO;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Initial javadoc for class ZIOBuilder.
 * TODO - Add content here
 *
 * Created Sep 14, 2005 10:37:27 AM
 * @author DNS   BOHMEG
 */
public class ZIOBuilder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 6628365794694258777L;

   /**
     * Method to build the ZIO segment.
     *
     * @param metaData
     *            The parameter object used to build the a ZIO segment.
     * @return The ZIO segment.
     */
    public Object build(HL7MetaData metaData) throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZIO segment = new ZIO();

        Person person = (Person) metaData.getEntity();

        try
        {
        	segment.setSetID("1");
        	//CCR12958, do not send empty string on every null date,
        	//empty string on ZIO is a delete
        	//only send delete if status is rejected or cancel/decline
        	EnrollmentStatus enrollmentStatus = person.getEnrollmentDetermination() == null ? null
                    : person.getEnrollmentDetermination().getEnrollmentStatus();

            if (enrollmentStatus != null)
            {
            	//Only send empty string on nulls to delete appointment if status is rejected or cancel/decline
            	if(StringUtils.equals(enrollmentStatus.getCode(), EnrollmentStatus.CODE_CANCELLED_DECLINED.getCode())
            			|| StringUtils.equals(enrollmentStatus.getCode(), EnrollmentStatus.CODE_REJECTED.getCode())
            			|| StringUtils.equals(enrollmentStatus.getCode(), EnrollmentStatus.CODE_REJECTED_INITIAL_APPLICATION_BY_VAMC.getCode())
            			|| StringUtils.equals(enrollmentStatus.getCode(), EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode()))
            	{
            		segment.setAppointmentRequestOn1010EZ(buildBooleanFor0136(person.getAppointmentRequestResponse()));
                	segment.setAppointmentRequestDate(DateFormatter.formatDate(person.getAppointmentRequestDate()));

            	}
            	else {

	            //********************************************
	        	//Send empty string if null CCR9927
            	//NO. Do not send empty string on every null - CCR12958.
	        	segment.setAppointmentRequestOn1010EZ(buildEmptyIfNull(buildBooleanFor0136(person.getAppointmentRequestResponse())));
	        	segment.setAppointmentRequestDate(buildEmptyIfNull(DateFormatter.formatDate(person.getAppointmentRequestDate())));
            	}
            }

        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build ZIO Segment due to an exception ", e);
        }

        return segment;
    }
}
