/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.segment.ZIE;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.util.builder.BuilderException;

//ESR Classes
import gov.va.med.esr.common.model.person.*;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;

/**
 * Class to build the ZIE segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ZIEBuilder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -5040868066713536443L;

   public ZIEBuilder() {
        super();
    }
    
    /**
     * Method to build the ZIE segment.
     * 
     * @param metaData
     *           The parameter object used to build the a ZIE segment.
     * @return The ZIE segment.
     */
    public Object build(HL7MetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof Person)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        ZIE segment = new ZIE();
        
        setDefaultValues(segment);
        segment.setSetID("1");
        
        Person person = (Person)metaData.getEntity();
        IneligibilityFactor ineligibility = person.getIneligibilityFactor();
        
        if (ineligibility != null) {
	        try {
	            //Set segment attributes
	            segment.setIneligibleDate(DateFormatter.formatDate(ineligibility.getIneligibleDate()));
	            segment.setIneligibleReason(ineligibility.getReason());
	            segment.setIneligibleVaroDecision(ineligibility.getVaroDecision());
	        }
	        catch (Exception e) {
	            throw new BuilderException( "Failed to build ZIE Segment due to an exception ", e);
	        }
        }
        
        return segment;
    }
    
    protected void setDefaultValues(Segment segment) 
    {
        ZIE zie = (ZIE) segment; 
        zie.setIneligibleDate(SegmentConstants.DEFAULT_VALUE);
        zie.setIneligibleReason(SegmentConstants.DEFAULT_VALUE);
        zie.setIneligibleVaroDecision(SegmentConstants.DEFAULT_VALUE);
    }
}