/********************************************************************
 * Copyright  2013  All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

//Framework Classes
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.segment.ZHP;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;

//ESR Classes
import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.person.Person;

/**
 * Class to build the ZHP segment.
 * CCR12064 
 * @author DNS   zhangs
 * @version 1.0
 */
public class ZHPBuilder extends AbstractSegmentBuilder
{  
  
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 4500473786960249887L;

   /**
     * Default contructor.
     */
    public ZHPBuilder()
    {
        super();
    }

    /**
     * Method to build the ZHP segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZHP segment.
     * @return The ZHP segment.
     */
    public Object build(HL7MetaData metaData) throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        List segments = new ArrayList();
        Person person = (Person) metaData.getEntity();

        try
        {
            int setID = 1;
            HealthBenefitProfile hbp = person.getHealthBenefitProfile();
            Set hbplans = hbp.getHealthBenefitPlans();
            if (hbplans != null)
            {
                Iterator iterPlans = hbplans.iterator();
                while (iterPlans.hasNext())
                {
                    HealthBenefitPlan plan = (HealthBenefitPlan) iterPlans.next();
                    if (plan != null)
                    {
                        ZHP segment = new ZHP();
                        setDefaultValues(segment);

                        segment.setSetID(String.valueOf(setID));
                        segment.setHBPCode(buildEmptyIfNull(plan.getPlanType().getCode()));
                        segment.setHBPLastUpdatedDate(buildEmptyIfNull(DateFormatter.formatDateTime(plan.getChangeDate(), DateFormatter.DATETIME_ZONE_FORMAT)));
                        segment.setHBPLastUpdatedBySource(buildEmptyIfNull(plan.getChangeSource().getCode()));
                        if(plan.getChangeSite() !=null) {
                        	segment.setHBPLastUpdatedBySite(buildEmptyIfNull(plan.getChangeSite().getCode()));
                        }
                                               
                        segments.add(segment);
                        setID += 1;
                    }
                }
            }


        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build ZHP Segment due to an exception ", e);
        }

        return segments;
    }
    
       
    protected String buildEmptyIfNull(String input)
    {
        return input == null ? StringUtils.EMPTY : input;
    } 
    
    protected void setDefaultValues(Segment segment)
    {
        ZHP zhp = (ZHP)segment;
        
        zhp.setHBPCode(SegmentConstants.DEFAULT_VALUE);
        zhp.setHBPLastUpdatedDate(SegmentConstants.DEFAULT_VALUE);
        zhp.setHBPLastUpdatedBySource(SegmentConstants.DEFAULT_VALUE);
        zhp.setHBPLastUpdatedBySite(SegmentConstants.DEFAULT_VALUE);
       
    }
}