/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZGD;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.person.Person;

/**
 * Class to build the ZGD segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ZGDBuilder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 3261940468437301290L;

   public ZGDBuilder() {
        super();
    }

    /**
     * Method to build the ZGD segment.
     * 
     * @param metaData
     *           The parameter object used to build the a ZGD segment.
     * @return The ZGD segment.
     */
    public Object build(HL7MetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof Person)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        ZGD segment = new ZGD();
        segment.setSetID("1");
        
        return segment;
    }
    
}