/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZEG;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.ee.EGTSetting;

/**
 * Class to build the ZEG segment.
 * 
 * @author Alex Yoon, Rajiv Patnaik
 * @version 1.0
 */ 
public class ZEGBuilder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 1333322110370769168L;

   public ZEGBuilder() {
        super();
    }

    /**
     * Method to build the ZEG segment.
     * 
     * @param metaData
     *           The parameter object used to build the a ZEG segment.
     * @return The ZEG segment.
     */
    public Object build(HL7MetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof EGTSetting)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        ZEG segment = new ZEG();
                
        EGTSetting egtSetting = (EGTSetting)metaData.getEntity();
        
        segment.setEgtPriorityValue(super.build(egtSetting.getPriorityGroup()));
        segment.setEffectiveDate(DateFormatter.formatDate(egtSetting.getEffectiveDate()));
        segment.setEgtType(super.build(egtSetting.getType()));
        segment.setRemarks(egtSetting.getComments());
        segment.setEgtChangeDate(DateFormatter.formatDate(egtSetting.getModifiedOn()));
        segment.setFederalRegisterDate(DateFormatter.formatDate(egtSetting.getFederalRegisterDate()));
        segment.setEnrollmentSubGroup(super.build(egtSetting.getPrioritySubGroup()));
        
        return segment;
    }

    
}