/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.ArrayList;
import java.util.List;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZE2;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.person.Person;

/**
 * Class to build the ZMH segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ZE2Builder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -6131162998748748108L;
   
    
    
    private static final String PENSION_CODE_TABLE = "VistA27.18";
  
    
    /**
     * Default contructor.
     */
    public ZE2Builder() {
        super();
    }
    
    
	/**
     * Method to build the ZMH segment.
     * 
     * @param metaData
     *           The parameter object used to build the a ZMH segment.
     * @return The ZMH segment.
     */
    public Object build(HL7MetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof Person)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        List segments = new ArrayList();
        Person person = (Person)metaData.getEntity();
        
        try {            
        	
        	MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        	
        	if (mba !=null && mba.getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION) !=null){
        		setZE2Segments(person, segments);        		 
        	}
        	
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build ZE2 Segment due to an exception ", e);
        }
        
        return segments;
    }
    private void setZE2Segments(Person person, List segments) throws Exception {
    	// Get MonetaryBenefit object.
    	
    	MonetaryBenefit mb = person.getMonetaryBenefitAward().getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION);
    	ZE2 segment = new ZE2();    	    	
    	segment.setPensionDate(buildPensionDate(mb.getPension()!= null ? mb.getPension(): null));
    	segment.setPensionAwardReasonCode(buildAwardReason(mb));    	
    	segment.setPensionTerminatedReason(buildTerminationReason(mb));
    	segments.add(segment);    	

    }
    
    private String buildPensionDate(Pension pension){
    	String pensionDate = "";
    	if(pension != null){
    		pensionDate = ElementFormatter.formatCodedElement(pension.getEffectiveDate() != null ? DateFormatter.formatDate(pension.getEffectiveDate()):"", pension.getTerminationDate() != null ? DateFormatter.formatDate(pension.getTerminationDate()):"");    		
    	}
    	
    	return pensionDate;
    	
    }
    
    private String buildAwardReason(MonetaryBenefit mb){
    	String awardReason = "";
    	if(mb.getPension() != null){
    		if(mb.getPension().getAwardReasonCode() != null){
    			awardReason = ElementFormatter.formatCodedElement(mb.getPension().getAwardReasonCode().getCode(),"",PENSION_CODE_TABLE); 
    		}    		
    	}
    	
    	return awardReason;
    	
    }
    
    private String buildTerminationReason(MonetaryBenefit mb){
    	String terminationReason = "";
    	if(mb.getPension() != null){
    		if(mb.getPension().getTerminationReasonCode1() != null){
    			terminationReason = ElementFormatter.formatCodedElement(mb.getPension().getTerminationReasonCode1().getCode(),"",PENSION_CODE_TABLE);    			
    			if(mb.getPension().getTerminationReasonCode2() != null){
    				terminationReason = terminationReason + "|" + ElementFormatter.formatCodedElement(mb.getPension().getTerminationReasonCode2().getCode(),"",PENSION_CODE_TABLE);    				
    				if(mb.getPension().getTerminationReasonCode3() != null){
    					terminationReason = terminationReason + "|" + ElementFormatter.formatCodedElement(mb.getPension().getTerminationReasonCode3().getCode(),"",PENSION_CODE_TABLE);    					
    					if(mb.getPension().getTerminationReasonCode4() != null){
    						terminationReason = terminationReason + "|" + ElementFormatter.formatCodedElement(mb.getPension().getTerminationReasonCode4().getCode(),"",PENSION_CODE_TABLE);    						
    					}    					
    				}    				
    			}    			
    		}    		
    	}
    	return terminationReason;
    	
    }
	   
    
}