package gov.va.med.esr.messaging.builder.message;

import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * Builds the ZDP segment for Z05 message based on different datatypes.
 * 
 * @author Rajiv Patnaik Created on Sep 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZDPZ05Builder extends AbstractSegmentBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -8992122860154479442L;

   /**
     * Method to build the ZDP segment for Z05 message based on different
     * datatypes.
     * 
     * @param metaData
     *            The parameter object used to build the a ZDP segment.
     * @return The ZDP segment.
     */
    public Object build(HL7MetaData metaData, PersonTriggerEvent triggerEvent)
            throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZDP segment = new ZDP();
        segment.setSetID("1");

        return segment;
    }

}