package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;
/**
 * Class to hold data required to create a ZDP segment.
 * 
 * @author Rajiv Patnaik
 * Created on Jan 5, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZDPMetaData extends HL7MetaData
{
    
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -4475270809442036918L;
   private Relationship relationship;
    private RelationFinancials relationFinancials;
    private String setId;

    /**
     * @param entity
     * @param relationship
     * @param relationFinancials
     * @param setId - Set Id is the first sequence in the ZDP sequence. 
     * 				  Could be 1,2 ,3.. depending on the number of spouse and dependents
     * 	
     */
    public ZDPMetaData(AbstractEntity entity, Relationship relationship,
            RelationFinancials relationFinancials, String setId)
    {
        super(entity);
        this.relationship = relationship;
        this.relationFinancials = relationFinancials;
        this.setId = setId;
    }

    /**
     * @return Returns the relationship.
     */
    public Relationship getRelationship()
    {
        return relationship;
    }

    /**
     * @return Returns the relationFinancials.
     */
    public RelationFinancials getRelationFinancials()
    {
        return relationFinancials;
    }
    /**
     * @return Returns the setId.
     */
    public String getSetId()
    {
        return setId;
    }
}
