package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;
/**
 * Class to hold data required to create a ZBT segment.
 * 
 * @author Rajiv Patnaik
 * Created on Jan 5, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZBTMetaData extends HL7MetaData
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -9074918178865740095L;

   private Integer incomeYear = null;

    private SiteIdentity siteIdentity = null;
    
    /**
     * @param entity
     */
    public ZBTMetaData(AbstractEntity entity, SiteIdentity siteIdentity, Integer incomeYear)
    {
        super(entity);
        this.incomeYear = incomeYear;
        this.siteIdentity = siteIdentity;
    }

    /**
     * @return Returns the incomeYear.
     */
    public Integer getIncomeYear()
    {
        return incomeYear;
    }
    /**
     * @return Returns the siteIdentity.
     */
    public SiteIdentity getSiteIdentity()
    {
        return siteIdentity;
    }
}
