/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.ZBT;
import gov.va.med.fw.util.builder.BuilderException;

//ESR Classes
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.person.*;

/**
 * Class to build the ZBT segment.
 * 
 * @author Alex Yoon
 * @author Rajiv Patnaik
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZBTBuilder extends AbstractSegmentBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -6000410851198993934L;

   public ZBTBuilder()
    {
        super();
    }

    /**
     * Method to build the ZBT segment.
     * 
     * @param metaData
     *            The parameter object used to build the a ZBT segment.
     * @return The ZBT segment.
     */
    public Object build(ZBTMetaData metaData) throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        ZBT segment = new ZBT();
        setDefaultValues(segment);
        
        segment.setSetID("1");

        Person person = (Person) metaData.getEntity();
        BeneficiaryTravel beneficiaryTravel = person.getBeneficiaryTravel(
                metaData.getIncomeYear(), metaData.getSiteIdentity()
                        .getVaFacility());

        if (beneficiaryTravel != null)
        {
            //Seq 2
            segment.setCertifiedDate(DateFormatter.formatDate(beneficiaryTravel
                    .getDateCertified()));
            //Seq 3
            segment.setEligible(buildBooleanForVA001(beneficiaryTravel
                    .getEligible()));
            //Seq 4
            segment.setCertifiedAmount(super.build(beneficiaryTravel.getAmountCertified()));
        }
        return segment;
    }
    
    protected void setDefaultValues(Segment segment)
    {
        ZBT zbt = (ZBT)segment;
        
        zbt.setCertifiedDate(SegmentConstants.DEFAULT_VALUE);
        zbt.setEligible(SegmentConstants.DEFAULT_VALUE);
        zbt.setCertifiedAmount(SegmentConstants.DEFAULT_VALUE);
        
    }
}