package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.messaging.constants.HL7Constants;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.util.builder.BuilderException;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * AE builder for outbound solicitated messages 
 *  
 * @author Rajiv Patnaik Created on Jul 14, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SolicitatedMessageAckAEBuilder extends AbstractMessageBuilder
{

    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -8715855928091943130L;
   private String messageType;
    
    /**
     * @return Returns the messageType.
     */
    public String getMessageType()
    {
        return messageType;
    }
    /**
     * @param messageType The messageType to set.
     */
    public void setMessageType(String messageType)
    {
        this.messageType = messageType;
    }
    public Message build(Object[] args) throws BuilderException
    {
        Message message = (Message) args[0];

        return this.build(message, (MessageLogEntry) args[1]);
    }

    public Message build(Message message, MessageLogEntry errorLogEntry)
            throws BuilderException
    {

        if ((message == null) || errorLogEntry == null)
        {
            throw new BuilderException(
                    "Invalid input parameters to build an object");
        }

        Message ack = null;

        try
        {
            List segments = new ArrayList();
            
            VAFacility sendingFacility = getLookupService()
            .getVaFacilityByStationNumber(message.getSendingFacility());            

            //Build MSH segment            
            segments.add(super.buildMSHSegment(sendingFacility, getMessageType()));
            
            
            //Build MSA segment
            segments.add(super.buildMSASegment(errorLogEntry.getAckType()
                    .getCode(), message.getMessageID(),errorLogEntry.getErrorText()));
            
            ///Add QRD/QRF from original message
            segments.add(message.getSegment(SegmentConstants.QRD));
            segments.add(message.getSegment(SegmentConstants.QRF));

            ack = new Message(segments, HL7Constants.ACK);
            
        } catch (Exception me)
        {
            throw new BuilderException(
                    "Failed to build solicitated AE message for message: " +message.getMessageData(),
                    me);
        } 
        
        return ack;

    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception
    {
        super.afterPropertiesSet();
        Validate.notNull(messageType, "messageType cannot be null");
    }
}