/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.segment.RF1;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.person.Person;

/**
 * Class to build the RF1 segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class RF1Builder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 8738885677781939119L;

   public RF1Builder() {
        super();
    }

    /**
     * Method to build the RF1 segment.
     * 
     * @param metaData
     *           The parameter object used to build the a RF1 segment.
     * @return The RF1 segment.
     */
    public Object build(HL7MetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof Person)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        RF1 segment = new RF1();
                
        return segment;
    }
    
}