package gov.va.med.esr.messaging.builder.message;

import gov.va.med.fw.hl7.segment.RCP;
import gov.va.med.fw.util.builder.BuilderException;

public class RCPBuilder extends AbstractSegmentBuilder {
       
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -9101925505525821388L;

   public RCPBuilder() { 
        super();
    }
    
    /**
     * Method to build the QRF segment.
     * 
     * @param metaData
     *           The parameter object used to build the a QRF segment.
     * @return The RCP segment.
     */
    public Object build(RCPMetaData metaData ) throws BuilderException {
        if((metaData == null)) {
            throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        RCP segment = new RCP();
        
        try {
            //segment.setResponse(metaData.getEwsponse());
            segment.setResponseDetail(metaData.getResponseDetail());     
            
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build RCP Segment due to an exception ", e);
        }
        
        return segment;
    }
    


}
