package gov.va.med.esr.messaging.builder.message;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.constants.HL7Constants;

/**
 * 
 * @author Rajiv Patnaik Created on Oct 19, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class QRYZ07Builder extends AbstractMessageBuilder
{


    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -4620020437957501774L;

   public Message build(Object[] args) throws BuilderException
    {
        return this.build((Person) args[0], (SiteIdentity) args[1],
                (Integer) args[2]);
    }

    /**
     * Method to build the QRYZ07 from person.
     * 
     * @param person
     *            The person who is source for message content.
     * @return The QRYZ07 message.
     * @throws BuilderException
     */
    public Message build(Person person, SiteIdentity siteIdentity,
            Integer incomeYear) throws BuilderException
    {
        if (person == null || siteIdentity == null)
        {
            throw new BuilderException(
                    "Invalid input parameters to build an object");
        }

        Message message = null;
        List segments = new ArrayList();

        try
        {
            segments.add(super.buildMSHSegment(siteIdentity,
                    HL7Constants.QRYZ07));

            segments.add(super.buildQRDSegment(person, null,
                    siteIdentity.getDfn(), Calendar.getInstance().getTime(),
                    HL7Constants.WHAT_SUBJECT_FILTER_DEMOG, incomeYear + "0000"));
            
            segments.add(super.buildQRFSegment(person));

            message = new Message(segments, HL7Constants.QRYZ07, true);
        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build QRYZ07 message due to an exception ", e);
        }

        return message;
    }


}