/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

//EDB Classes

/**
 * Class that functions as parameter object to build QRF segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class QRFMetaData extends HL7MetaData {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -2972413474696776902L;
   private String whereSubjectFilter = null;
    private String whatUserQualifier = null;
    private String otherQuerySubjectFilter = null;
        
    /**
     * Constructor that takes entity object to build a segment.
     * 
     * @param entity
     *           The entity that is source of segment data.
     */
    public QRFMetaData (AbstractEntity entity) {
        super(entity);
    }
    
    
    /**
     * Return the where subject filter.
     * 
     * @return The where subject filter.
     */
    public String getWhereSubjectFilter() {
        return this.whereSubjectFilter;
    }
    
    /**
     * Set the where subject filter.
     * 
     * @param whereSubjectFilter
     * 			The where subject filter to set.
     */
    public void setWhereSubjectFilter(String whereSubjectFilter) {
        this.whereSubjectFilter = whereSubjectFilter;
    }
    /**
     * @return Returns the otherSubjectQueryFilter.
     */
    public String getOtherQuerySubjectFilter()
    {
        return otherQuerySubjectFilter;
    }
    /**
     * @param otherSubjectQueryFilter The otherSubjectQueryFilter to set.
     */
    public void setOtherQuerySubjectFilter(String otherQuerySubjectFilter)
    {
        this.otherQuerySubjectFilter = otherQuerySubjectFilter;
    }
    /**
     * @return Returns the whatUserQualifier.
     */
    public String getWhatUserQualifier()
    {
        return whatUserQualifier;
    }
    /**
     * @param whatUserQualifier The whatUserQualifier to set.
     */
    public void setWhatUserQualifier(String whatUserQualifier)
    {
        this.whatUserQualifier = whatUserQualifier;
    }
}
