/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import gov.va.med.fw.hl7.segment.QRF;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Class to build the QRF segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class QRFBuilder extends AbstractSegmentBuilder {
       
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -9101925505525821388L;

   public QRFBuilder() { 
        super();
    }
    
    /**
     * Method to build the QRF segment.
     * 
     * @param metaData
     *           The parameter object used to build the a QRF segment.
     * @return The QRF segment.
     */
    public Object build(QRFMetaData metaData ) throws BuilderException {
        if((metaData == null)) {
            throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        QRF segment = new QRF();
        
        try {
            segment.setWhereSubjectFilter(metaData.getWhereSubjectFilter());
            segment.setWhatUserQualifier(metaData.getWhatUserQualifier());		
            segment.setOtherQuerySubjectFilter(metaData.getOtherQuerySubjectFilter());
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build QRF Segment due to an exception ", e);
        }
        
        return segment;
    }
    
}