/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

//EDB Classes

/**
 * Class that functions as parameter object to build QRD segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class QRDMetaData extends HL7MetaData {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -3748212690244917807L;
   private String queryDateTime = null;
    private String queryId = null;
    private String whoSubjectFilter = null;
    private String whatSubjectFilter = null;
    private String whatDepartmentCode = null;
    
    /**
     * Constructor that takes entity object to build a segment.
     * 
     * @param entity
     *           The entity that is source of segment data.
     */
    public QRDMetaData (AbstractEntity entity) {
        super(entity);
    }
    
    
    /**
     * @return Returns the queryDateTime.
     */
    public String getQueryDateTime()
    {
        return queryDateTime;
    }
    /**
     * @param queryDateTime The queryDateTime to set.
     */
    public void setQueryDateTime(String queryDateTime)
    {
        this.queryDateTime = queryDateTime;
    }
    /**
     * @return Returns the queryId.
     */
    public String getQueryId()
    {
        return queryId;
    }
    /**
     * @param queryId The queryId to set.
     */
    public void setQueryId(String queryId)
    {
        this.queryId = queryId;
    }
    /**
     * @return Returns the whoSubjectFilter.
     */
    public String getWhoSubjectFilter()
    {
        return whoSubjectFilter;
    }
    /**
     * @param whoSubjectFilter The whoSubjectFilter to set.
     */
    public void setWhoSubjectFilter(String whoSubjectFilter)
    {
        this.whoSubjectFilter = whoSubjectFilter;
    }
    /**
     * Return the what subject filter.
     * 
     * @return The what subject filter.
     */
    public String getWhatSubjectFilter() {
        return this.whatSubjectFilter;
    }
    
    /**
     * Set the what subject filter.
     * 
     * @param whatSubjectFilter
     * 			The what subject filter to set.
     */
    public void setWhatSubjectFilter(String whatSubjectFilter) {
        this.whatSubjectFilter = whatSubjectFilter;
    }
    
    /**
     * Return the what department code.
     * 
     * @return The what department code.
     */
    public String getWhatDepartmentCode() {
        return this.whatDepartmentCode;
    }
    
    /**
     * Set the what department code.
     * 
     * @param whatDepartmentCode
     * 			The what department code to set.
     */
    public void setWhatDepartmentCode(String whatDepartmentCode) {
        this.whatDepartmentCode = whatDepartmentCode;
    }
}
