	/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import gov.va.med.fw.hl7.segment.QRD;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.service.MessagingService;

/**
 * Class to build the QRD segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class QRDBuilder extends AbstractSegmentBuilder {
    
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -33629223884724893L;
   private MessagingService messagingService = null;
    
    public QRDBuilder() {
        super();
    }
    
    /**
     * Method to build the QRD segment.
     * 
     * @param metaData
     *           The parameter object used to build the a QRD segment.
     * @return The QRD segment.
     */
	   protected boolean isNull(String data)
	    {
	        return (data == null);
	    }
    public Object build(QRDMetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof Person)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        QRD segment = new QRD();
        
        try {
			segment.setQueryDate(metaData.getQueryDateTime());
			
            segment.setQueryFormatCode(HL7Constants.QUERY_FORMAT_CODE);
            segment.setQueryPriority(HL7Constants.QUERY_PRIORITY);
            
            String queryID = metaData.getQueryId() != null ? 
                metaData.getQueryId() : messagingService.generateControlIdentifier();
            segment.setQueryID(queryID);
            
            segment.setQuantityLimitedRequest(HL7Constants.QUANTITY_LIMITED_REQUEST);
            segment.setWhoSubjectFilter(metaData.getWhoSubjectFilter());
            segment.setWhatSubjectFilter(metaData.getWhatSubjectFilter());
            segment.setWhatDepartmentDataCode(metaData.getWhatDepartmentCode());
            segment.setQueryResultLevel(HL7Constants.QUERY_RESULT_LEVEL);
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build QRD Segment due to an exception ", e);
        }
        
        return segment;
    }
    /**
     * @return Returns the messagingService.
     */
    public MessagingService getMessagingService()
    {
        return messagingService;
    }
    /**
     * @param messagingService The messagingService to set.
     */
    public void setMessagingService(MessagingService messagingService)
    {
        this.messagingService = messagingService;
    } 
    
 
}