package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.hl7.segment.QPD;
import gov.va.med.fw.util.builder.BuilderException;

public class QPDBuilder extends AbstractSegmentBuilder {
    

    
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -33629223884724893L;
   private MessagingService messagingService = null;
   private PersonHelperService personHelperService;
    
    public QPDBuilder() {
        super();
    }
    
    /**
     * Method to build the QRD segment.
     * 
     * @param metaData
     *           The parameter object used to build the a QRD segment.
     * @return The QRD segment.
     */
       protected boolean isNull(String data)
        {
            return (data == null);
        }
    public Object build(QPDMetaData metaData ) throws BuilderException {
        if((metaData == null) || 
           (metaData.getEntity() == null) ||
           !(metaData.getEntity() instanceof Person)) {
                throw new BuilderException("Invalid input parameter to build a segment");
        }
        
        Person person = (Person) metaData.getEntity();            
        QPD segment = new QPD();
        
        try {
            segment.setComment(metaData.getComment());
            
            //segment.setId(metaData.getId());
                       
            String dfn = metaData.getDfn() != null ? 
                metaData.getDfn() : messagingService.generateControlIdentifier();
            segment.setDFN(dfn);
            
            segment.setEventType(metaData.getEventType());
            String VPIDKey = person.getVPIDEntityKey() == null ? null : person
                    .getVPIDEntityKey().getVPID();             
            segment.setICN(getPersonHelperService().getICNChecksum(VPIDKey));
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build QPD Segment due to an exception ", e);
        }
        
        return segment;
    }
    /**
     * @return Returns the messagingService.
     */
    public MessagingService getMessagingService()
    {
        return messagingService;
    }
    /**
     * @param messagingService The messagingService to set.
     */
    public void setMessagingService(MessagingService messagingService)
    {
        this.messagingService = messagingService;
    } 
    
    /**
     * @return Returns the personHelperService.
     */
    public PersonHelperService getPersonHelperService()
    {
        return personHelperService;
    }
    
    /**
     * @param personHelperService The personHelperService to set.
     */
    public void setPersonHelperService(PersonHelperService personHelperService)
    {
        this.personHelperService = personHelperService;
    }
 


}
