/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

//EDB Classes
import gov.va.med.esr.common.model.messaging.SiteIdentity;
/**
 * Class that functions as parameter object to build PID segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class PIDMetaData extends HL7MetaData {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 1303088968597491872L;
   private SiteIdentity siteIdentity = null;
        
    /**
     * Constructor that takes entity object to build a segment.
     * 
     * @param entity
     *           The entity that is source of segment data.
     */
    public PIDMetaData (AbstractEntity entity) {
        super(entity);
    }
    
    
    /**
     * Return the siteIdentity.
     * 
     * @return SiteIdentity.
     */
    public SiteIdentity getSiteIdentity() {
        return this.siteIdentity;
    }
    
    /**
     * Set siteIdentity.
     * 
     * @param siteIdentity
     * 			The siteIdentity to set.
     */
    public void setSiteIdentity(SiteIdentity siteIdentity) {
        this.siteIdentity = siteIdentity;
    }
}
