/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;

/**
 * Class to build the PID segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class PIDBuilder extends AbstractPIDBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 2945945349129895598L;

   /**
     * Default contructor.
     */
    public PIDBuilder()
    {
        super();
    }

    /**
     * Method to build the PID segment.
     * 
     * @param metaData
     *            The parameter object used to build the a PID segment.
     * @return The PID segment.
     */
    public Object build(PIDMetaData metaData) throws BuilderException
    {
        if ((metaData == null) || (metaData.getEntity() == null)
                || !(metaData.getEntity() instanceof Person)
                || (metaData.getSiteIdentity() == null))
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        PID segment = new PID();        
        super.setDefaultValues(segment);
        
        SiteIdentity siteIdentity = metaData.getSiteIdentity();
        Person person = (Person) metaData.getEntity();
        
        //Note RP 09/02/05. Segment has been built to match the requirements for ORUZ04.
        //i.e Seq 1,2,3,5,7,19
        //Will add additional sequences if necessary based on requirements
        try
        {
        	segment.setSetID("1");
            
        	//Seq 2
            String VPIDKey = person.getVPIDEntityKey() == null ? null : person
                    .getVPIDEntityKey().getVPID();             
            segment.setPrimaryID(getPersonHelperService().getICNChecksum(VPIDKey));
            
            //Sequence 3 
            segment.setPatientIdentifierList(getPatientIdentifierList(person,
                    siteIdentity));
            //Seq 4
            segment.setAlternatePatientID(null); //Not used - backward
            //Seq 5
            segment.setPatientName(ElementFormatter.formatName(Name 
                    .getNameOfType(person.getNames(), NameType.LEGAL_NAME
                            .getName())));
            //Seq 7
            if(person.getBirthRecord() != null)
            {
                segment.setDOB(DateFormatter.formatDate(person.getBirthRecord().getBirthDate()));
            }
            //Seq 8
            segment.setSex(buildGender(person.getGender()));
            //Seq 19
            setSSN(person, segment);
            
             
        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build PID Segment due to an exception ", e);
        }

        return segment;
    }
    

}