/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Message;

import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.constants.HL7Constants;

/**
 * Class to build the ORUZ11 message from a person object. 
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ORUZ11Builder extends AbstractZ11Builder {
    
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 8205861178474349478L;

   /**
     * Method to build the ORUZ11 message. 
     * 
     * @param object array
     * 			The person who is source of message content.
     * @param siteIdentity
     * 			The siteIdentity that is a destination of message.
     * @return The ORUZ11 message.
     * @throws BuilderException
     */
    public Message build(Object[] args) throws BuilderException
    {
        return this.build((Person)args[0], (SiteIdentity)args[1]);
    }
    
    /**
     * Method to build the ORUZ11 message. 
     * 
     * @param 	The person who is source of message content.
     * @param siteIdentity
     * 			The siteIdentity that is a destination of message.
     * @return 	The ORUZ11 message.
     * @throws 	BuilderException
     */
    public Message build(Person person, SiteIdentity siteIdentity) throws BuilderException {
        
        if (person == null || siteIdentity == null)
        {
            throw new BuilderException(
                    "Invalid input parameters to build an object");
        }
        
        Message message = null;
        List segments = new ArrayList();
	    
        try { 
 
            segments.add(super.buildMSHSegment(siteIdentity,
                    HL7Constants.ORUZ11));
            
            segments = buildCommonZ11Segments(segments, person, siteIdentity);
            
            message = new Message(segments, HL7Constants.ORUZ11, true);
            
        }
        catch(InvalidSegmentException me)
        {
            throw new BuilderException(
                "Failed to build ORUZ11 message due to an segment exception ",
                me);
        }
        catch(InvalidMessageException me)
        {
            throw new BuilderException(
                "Failed to build ORUZ11 message due to an exception ", me);
        }  
        
        
        if(super.logger.isDebugEnabled())
        {
            super.logger.debug("ORUZ11 Message = " + message.getMessageData());
        }
                
        return message;
    }
}