/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.ArrayList;
import java.util.List;

//Framework classes
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.util.builder.BuilderException;

//ESR Classes
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.messaging.SiteIdentity;

/**
 * Class to build the ORUZ10 message from a person object.
 * 
 * @author Alex Yoon, Rajiv Patnaik
 * @version 1.0
 */
public class ORUZ10Builder extends AbstractZ10Builder
{

    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 8591856396150528870L;

   /**
     * Default constructor
     */
    public ORUZ10Builder()
    {
        super();
    }

    /**
     * Method to build the ORUZ10 message.
     * 
     * @param object
     *            array The person who is source of message content.
     * @param siteIdentity
     *            The siteIdentity that is a destination of message.
     * @return The ORUZ10 message.
     * @throws BuilderException
     */
    public Message build(Object[] args) throws BuilderException
    {
        return this.build((Person) args[0], (SiteIdentity) args[1],
                (args[3] == null ? null : (PersonTriggerEvent) args[3]));
    }

    /**
     * Method to build the ORUZ10 message.
     * 
     * @param The
     *            person who is source of message content.
     * @param siteIdentity
     *            The siteIdentity that is a destination of message.
     * @return The ORUZ10 message.
     * @throws BuilderException
     */
    public Message build(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent) throws BuilderException
    {
        if(person == null || siteIdentity == null || triggerEvent == null )
        {
            throw new BuilderException(
            	"Invalid input parameters to build an a ORUZ04 message ");
        }
        
 
        Message message = null;
        List segments = new ArrayList();

        try
        {
            segments.add(super.buildMSHSegment(siteIdentity,
                    HL7Constants.ORUZ10));
            
            segments = super.buildCommonZ10Segments(segments, person,
                    siteIdentity, (IncomeYearTriggerEvent) triggerEvent);
            
            message = new Message(segments, HL7Constants.ORUZ10, true);
            
        } catch (InvalidSegmentException me)
        {
            throw new BuilderException(
                    "Failed to build ORUZ10 message due to an segment exception ",
                    me);
        } catch (InvalidMessageException me)
        {
            throw new BuilderException(
                    "Failed to build ORUZ10 message due to an exception ", me);
        }

        if (super.logger.isDebugEnabled())
        {
            super.logger.debug("ORUZ10 Message = " + message.getMessageData());
        }

        return message;
    }
}