/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

// Framework classes
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

/**
 * Class serves as parameter object for building MSA segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class MSAMetaData extends HL7MetaData {

   /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -2354907884891812104L;

   private String ackCode; //AA or AE

   private String controlID;

   private String textMessage;

   /**
    * @param arg0
    * @param arg1
    */
   public MSAMetaData(AbstractEntity entity, Message msg) {
      super(entity, msg);
   }
   
   /**
    * Constructor that takes entity object to build a segment.
    * 
    * @param entity
    *           The entity that is source of segment data.
    */
   public MSAMetaData (AbstractEntity entity) {
       super(entity);
   }

   /**
    * Returns the ACK code.
    * 
    * @return The ACK code
    */
   public String getACKCode() {
      return this.ackCode;
   }

   /**
    * Set the ACK code.
    * 
    * @param ackCode
    *           The ACK code to set.
    */
   public void setACKCode(String ackCode) {
      this.ackCode = ackCode;
   }

   /**
    * Return the control id.
    * 
    * @return The control id.
    */
   public String getControlID() {
      return this.controlID;
   }

   /**
    * Set the control id.
    * 
    * @param controlID
    *           The control id to set.
    */
   public void setControlID(String controlID) {
      this.controlID = controlID;
   }

   /**
    * Return the text message.
    * 
    * @return The text message.
    */
   public String getTextMessage() {
      return this.textMessage;
   }

   /**
    * Set the text message.
    * 
    * @param textMessage
    *           The text message.
    */
   public void setTextMessage(String textMessage) {
      this.textMessage = textMessage;
   }
}