/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Class to build MSA segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class MSABuilder extends AbstractSegmentBuilder {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -1087117370603040179L;

   public MSABuilder() {
        super();
    }
    
    /**
     * Method to build the MSA segment.
     * 
     * @param metaData
     *           The parameter object that is used to build a MSA segment.
     * @return The MSA segment.
     */
    public Object build(MSAMetaData metaData) throws BuilderException {
        MSA segment = new MSA();
        
        try {
            segment.setAcknowledgementCode( metaData.getACKCode() );
            segment.setMessageControlID( metaData.getControlID() );
            if(metaData.getTextMessage() != null) 
                segment.setTextMessage( metaData.getTextMessage() );
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build MSA Segment due to an exception ", e);
        }
        
        return segment;
    }
}