/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.Date;

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

//ESR Classes

/**
 * Class that functions as parameter object to build MFI segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class MFIMetaData extends HL7MetaData {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 8934709149423862295L;
   private String masterFileIDSegment = null;
    private String masterFileIDSegmentName = null;
    private String masterFileIDCodingSystem = null;
    private String masterFileIDFileNumber = null;
    private String masterFileIDFileName = null;
    private String fileLevelEventCode = null;
    private Date enteredDate = null;
    private String responseLevelCode = null;
    
    /**
     * Constructor that takes entity object to build a segment.
     * 
     * @param entity
     *           The entity that is source of segment data.
     */
    public MFIMetaData (AbstractEntity entity) {
        super(entity);
    }
    
    /**
     * Return the Master File ID Segment.
     * 
     * @return The Master File ID Segment.
     */
    public String getMasterFileIDSegment() {
        return this.masterFileIDSegment;
    }
    
    /**
     * Set the Master File ID Segment.
     * 
     * @param masterFileIDSegment
     * 			Master File ID Segment.
     */
    public void setMasterFileIDSegment(String masterFileIDSegment) {
        this.masterFileIDSegment = masterFileIDSegment;
    }
    
    /**
     * Return the Master File ID Segment Name.
     * 
     * @return The Master File ID Segment Name.
     */
    public String getMasterFileIDSegmentName() {
        return this.masterFileIDSegmentName;
    }
    
    /**
     * Set the Master File ID Segment Name.
     * 
     * @param masterFileIDSegmentName
     * 			Master File ID Segment Name.
     */
    public void setMasterFileIDSegmentName(String masterFileIDSegmentName) {
        this.masterFileIDSegmentName = masterFileIDSegmentName;
    }
    
    /**
     * Return the Master File ID Coding System.
     * 
     * @return The Master File ID Coding System.
     */
    public String getMasterFileIDCodingSystem() {
        return this.masterFileIDCodingSystem;
    }
    
    /**
     * Set the Master File ID Coding System.
     * 
     * @param masterFileIDCodingSystem
     * 			Master File ID Coding System.
     */
    public void setMasterFileIDCodingSystem(String masterFileIDCodingSystem) {
        this.masterFileIDCodingSystem = masterFileIDCodingSystem;
    }
    
    /**
     * Return the Master File ID File Number.
     * 
     * @return The Master File ID File Number.
     */
    public String getMasterFileIDFileNumber() {
        return this.masterFileIDFileNumber;
    }
    
    /**
     * Set the Master File ID File Number.
     * 
     * @param masterFileIDFileNumber
     * 			Master File ID File Number.
     */
    public void setMasterFileIDFileNumbert(String masterFileIDFileNumber) {
        this.masterFileIDFileNumber = masterFileIDFileNumber;
    }
    
    /**
     * Return the Master File ID File Name.
     * 
     * @return The Master File ID File Name.
     */
    public String getMasterFileIDFileName() {
        return this.masterFileIDFileName;
    }
    
    /**
     * Set the Master File ID File Name.
     * 
     * @param masterFileIDFileName
     * 			Master File ID File Name.
     */
    public void setMasterFileIDFileName(String masterFileIDFileName) {
        this.masterFileIDFileName = masterFileIDFileName;
    }
    
    /**
     * Return the File Level Event Code.
     * 
     * @return The File Level Event Code.
     */
    public String getFileLevelEventCode() {
        return this.fileLevelEventCode;
    }
    
    /**
     * Set the File Level Event Code.
     * 
     * @param fileLevelEventCode
     * 			File Level Event Code.
     */
    public void setFileLevelEventCode(String fileLevelEventCode) {
        this.fileLevelEventCode = fileLevelEventCode;
    }
    
    /**
     * Return the Entered Date.
     * 
     * @return The Entered Date.
     */
    public Date getEnteredDate() {
        return this.enteredDate;
    }
    
    /**
     * Set the Entered Date.
     * 
     * @param enteredDate
     * 			The Entered Date.
     */
    public void setEnteredDate(Date enteredDate) {
        this.enteredDate = enteredDate;
    }
    
    /**
     * Return the Response Level Code.
     * 
     * @return The Response Level Code.
     */
    public String getResponseLevelCode() {
        return this.responseLevelCode;
    }
    
    /**
     * Set the Response Level Code.
     * 
     * @param responseLevelCode
     * 			Response Level Code.
     */
    public void setResponseLevelCode(String responseLevelCode) {
        this.responseLevelCode = responseLevelCode;
    }
}
