/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.segment.MFI;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Class to build the MFI segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class MFIBuilder extends AbstractSegmentBuilder
{
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -198901668340541998L;

   public MFIBuilder()
    {
        super();
    }

    /**
     * Method to build the MFI segment.
     * 
     * @param metaData
     *            The parameter object used to build the a MFI segment.
     * @return The MFI segment.
     */
    public Object build(MFIMetaData metaData) throws BuilderException
    {
        if (metaData == null)
        {
            throw new BuilderException(
                    "Invalid input parameter to build a segment");
        }

        MFI segment = new MFI();

        try
        {
            //Build Master File Identifier that is HL7 coded element.
            String masterFileId = null;
            masterFileId = ((metaData.getMasterFileIDSegment() != null) ? metaData
                    .getMasterFileIDSegment()
                    : StringUtils.EMPTY);
            masterFileId += "~"
                    + ((metaData.getMasterFileIDSegmentName() != null) ? metaData
                            .getMasterFileIDSegmentName()
                            : StringUtils.EMPTY);
            masterFileId += "~"
                    + ((metaData.getMasterFileIDCodingSystem() != null) ? metaData
                            .getMasterFileIDCodingSystem()
                            : StringUtils.EMPTY);
            masterFileId += "~"
                    + ((metaData.getMasterFileIDFileNumber() != null) ? metaData
                            .getMasterFileIDFileNumber()
                            : StringUtils.EMPTY);
            masterFileId += "~"
                    + ((metaData.getMasterFileIDFileName() != null) ? metaData
                            .getMasterFileIDFileName() : StringUtils.EMPTY);

            segment.setMasterFileID(masterFileId);

            segment.setMasterFileApplicationID(null); //Not used.

            segment.setEventCode(metaData.getFileLevelEventCode());

            segment.setEnteredDate(DateFormatter.formatDateTime(metaData
                    .getEnteredDate(), DateFormatter.DATETIME_ZONE_FORMAT));

            segment.setEffectiveDate(null); //Not used.

            segment.setResponseLevelCode(metaData.getResponseLevelCode());
        } catch (Exception e)
        {
            throw new BuilderException(
                    "Failed to build MFI Segment due to an exception ", e);
        }

        return segment;
    }
}