/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.Date;

//Framework Classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

//ESR Classes

/**
 * Class that functions as parameter object to build MFE segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class MFEMetaData extends HL7MetaData {
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 618697569799245957L;
   private String recordLeveEventCode = null;
    private String mfnControlID = null;
    private Date effectiveDate = null;
    private Date primaryKeyValueEffectiveDate = null;
    private String primaryKeyValueFileName = null;
    private String primaryKeyValueCodingSystem = null;
    
    /**
     * Constructor that takes entity object to build a segment.
     * 
     * @param entity
     *           The entity that is source of segment data.
     */
    public MFEMetaData (AbstractEntity entity) {
        super(entity);
    }
    
    /**
     * Return the Record Level Event Code.
     * 
     * @return The Record Level Event Code.
     */
    public String getRecordLeveEventCode() {
        return this.recordLeveEventCode;
    }
    
    /**
     * Set the Record Level Event Code.
     * 
     * @param recordLeveEventCode
     * 			The Record Level Event Code.
     */
    public void setRecordLeveEventCode(String recordLeveEventCode) {
        this.recordLeveEventCode = recordLeveEventCode;
    }
    
    /**
     * Return the MFN Control ID.
     * 
     * @return The MFN Control ID.
     */
    public String getMfnControlID() {
        return this.mfnControlID;
    }
    
    /**
     * Set the MFN Control ID.
     * 
     * @param mfnControlID
     * 			The MFN Control ID.
     */
    public void setMfnControlID(String mfnControlID) {
        this.mfnControlID = mfnControlID;
    }
    
    /**
     * Return the Effective Date.
     * 
     * @return The Effective Date.
     */
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }
    
    /**
     * Set the Effective Date.
     * 
     * @param effectiveDate
     * 			The Effective Date.
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
    /**
     * Return the Primary Key Value Effective Date.
     * 
     * @return The Primary Key Value Effective Date.
     */
    public Date getPrimaryKeyValueEffectiveDate() {
        return this.primaryKeyValueEffectiveDate;
    }
    
    /**
     * Set the Primary Key Value Effective Date.
     * 
     * @param primaryKeyValueEffectiveDate
     * 			The Primary Key Value Effective Date.
     */
    public void setPrimaryKeyValueEffectiveDate(Date primaryKeyValueEffectiveDate) {
        this.primaryKeyValueEffectiveDate = primaryKeyValueEffectiveDate;
    }
    
    /**
     * Return the Primary Key Value File Name.
     * 
     * @return The Primary Key Value File Name.
     */
    public String getPrimaryKeyValueFileName() {
        return this.primaryKeyValueFileName;
    }
    
    /**
     * Set the Primary Key Value File Name.
     * 
     * @param primaryKeyValueFileName
     * 			The Primary Key Value File Name.
     */
    public void setPrimaryKeyValueFileName(String primaryKeyValueFileName) {
        this.primaryKeyValueFileName = primaryKeyValueFileName;
    }
    
    /**
     * Return the Primary Key Value Coding System.
     * 
     * @return The Primary Key Value Coding System.
     */
    public String getPrimaryKeyValueCodingSystem() {
        return this.primaryKeyValueCodingSystem;
    }
    
    /**
     * Set the Primary Key Value Coding System.
     * 
     * @param primaryKeyValueCodingSystem
     * 			The Primary Key Value Coding System.
     */
    public void setPrimaryKeyValueCodingSystem(String primaryKeyValueCodingSystem) {
        this.primaryKeyValueCodingSystem = primaryKeyValueCodingSystem;
    }
}
