/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Library Classes
import org.apache.commons.lang.Validate;

//ESR Classes
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.util.StringUtils;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class ElementFormatter
{

    public static String formatName(Name name)
    {
        StringBuffer formattedName = new StringBuffer();

        if (name != null)

        {
            Validate.notNull(name, "name is required (cannot be null).");

            formattedName.append(((name.getFamilyName() != null) ? name
                    .getFamilyName() : ""));
            formattedName.append("~"
                    + ((name.getGivenName() != null) ? name.getGivenName() : ""));
            formattedName.append("~"
                    + ((name.getMiddleName() != null) ? name.getMiddleName()
                            : ""));
            // ccr 10218
            formattedName.append("~" 
                    + ((name.getSuffix() != null) ? name.getSuffix()
                            : ""));
        }
        return formattedName.toString();
    }

    /**
     * Address Formatting for Address Datatype AD
     * 
     * @param address
     * @return
     */
    
    public static String formatAddress(Address address)
    {
    	if(address == null)
    		return null;

        StringBuffer formattedAddress = new StringBuffer();
        
        formattedAddress.append((address.getLine1() != null) ? address.getLine1()
                : "");
        formattedAddress.append("~"
                + ((address.getLine2() != null) ? address.getLine2() : ""));
        formattedAddress.append("~"
                + ((address.getCity() != null) ? address.getCity() : ""));
        formattedAddress.append("~"
                + ((address.getState() != null) ? address.getState() : ""));
        formattedAddress.append("~"
                + ((address.getZipCode() != null) ? address.getZipCode() : ""));

        if ((address.getZipPlus4() != null) && (address.getZipPlus4() != ""))
        {
            formattedAddress.append("-" + address.getZipPlus4());
        }

        //Component 6
        formattedAddress.append("~" + ((address.getCountry()) != null ? address.getCountry() : StringUtils.EMPTY)); //
        formattedAddress.append("~"); //Address type not used 
        formattedAddress.append("~"
                + ((address.getLine3() != null) ? address.getLine3() : ""));

        return formattedAddress.toString();
    }

    /**
     * Method that formats coded element in HL7 "code~desc~codingSystem".
     * 
     * @param code
     *            The first element of coded element.
     * @param desc
     *            The second element of coded element.
     * @param codingSystem
     *            The last element of coded element.
     * @return formatted coded element.
     */
    public static String formatCodedElement(String code, String desc,
            String codingSystem)
    {
        StringBuffer formattedElement = new StringBuffer();

        formattedElement.append(((code != null) ? code : SegmentConstants.DEFAULT_VALUE));
        formattedElement.append("~" + ((desc != null) ? desc : SegmentConstants.DEFAULT_VALUE));
        formattedElement.append("~" + ((codingSystem != null) ? codingSystem : SegmentConstants.DEFAULT_VALUE));

        return formattedElement.toString();
    }

    /**
     * Method that formats coded element in HL7 "code~desc".
     * 
     * @param code
     *            The first element of coded element.
     * @param desc
     *            The second element of coded element.
     * @return formatted coded element.
     */
    public static String formatCodedElement(String code, String desc)
    {
        StringBuffer formattedElement = new StringBuffer();

        formattedElement.append(((code != null) ? code : SegmentConstants.DEFAULT_VALUE));
        formattedElement.append("~" + ((desc != null) ? desc : SegmentConstants.DEFAULT_VALUE));

        return formattedElement.toString();
    }

}