/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.text.SimpleDateFormat;
import java.util.Date;

//Library Classes
import org.apache.commons.lang.Validate;

//ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;


/**
 * @author Alex Yoon
 * @version 1.0
 */
public class DateFormatter {

	public static final String DATETIME_ZONE_FORMAT = "yyyyMMddHHmmssZ";

    private static final String DEFAULT_DATETIME_FORMAT = "yyyyMMddHHmmss";
	private static final String DEFAULT_DATE_FORMAT = "yyyyMMdd"; 

	public static String formatDateTime(Date date)
	{
		if (date == null) {
			return null;
		}
		return formatDateTime(date, DEFAULT_DATETIME_FORMAT);
	}
	
	public static String formatDateTime(Date date, String format) {
		if (date == null) {
			return null;
		}
		
		Validate.notNull(format, "Format is required (cannot be null).");
		
		SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
		return  simpleFormat.format(date);
	}
		
	public static String formatDate(Date date)
	{
		if (date == null) {
			return null;
		}
		return formatDate(date, DEFAULT_DATE_FORMAT);
		
	}
	
	public static String formatDate(Date date, String format)
	{
	    if (date == null) {
			return null;
		}
		
	    Validate.notNull(format, "Format is required (cannot be null).");
		
		SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
		return  simpleFormat.format(date);
	}
	
	public static String formatDate(ImpreciseDate date)
	{
		if (date == null) {
			return null;
		}

		if (date.getString() != null) {
		    //If length is < 8 (yyyyMMdd), then pad zeroes to the right to make it a yyyyMMdd format.
		    return date.getString() + getPaddedZeroes(8 - date.getString().length()); 
		}
		else {
		    return formatDate(date.getDate(), DEFAULT_DATE_FORMAT);
		}
	} 
	
	private static String getPaddedZeroes(int len)
	{
	    StringBuffer strBuf = new StringBuffer();
	    if (len >0)
	    {
	        for (int i=0; i< len; i++)
	        {
	            strBuf.append('0');
	        }
	    }
	    return strBuf.toString();
	}	
	
	public static String formatDate(ImpreciseDate date, String format)
	{
		if (date == null) {
			return null;
		}

	    Validate.notNull(format, "Format is required (cannot be null).");	    
		
	    return formatDate(date.getDate(), format);
	}	
	
	/**
	 * This method formats the ImpreciseDate with yyyyMMddHHmmssZ if time presents,
	 * otherwise farmats with yyyyMMdd.
	 * @param date
	 * @return formatted date.
	 */
	public static String formatDateWithTime(ImpreciseDate date)
	{
		String dateFormat=DEFAULT_DATE_FORMAT;
		if (date == null) {
			return null;
		}
		if(date!=null)
    	{        		
    		if(date.isTimePresent())
    		{
    			dateFormat=DATETIME_ZONE_FORMAT;
    		}    		
    	}
	    Validate.notNull(dateFormat, "Format is required (cannot be null).");	    
		
	    return formatDate(date.getDate(), dateFormat);
	}	
}
