/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

// Framework classes
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.model.AbstractEntity;

/**
 * This class functions as parameter object for building a BTS segment.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class BTSMetaData extends HL7MetaData {
   
   /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 1242415573336089151L;
   private int messageCount = 0;

   /**
    * Constructor that takes entity object to build a segment.
    * 
    * @param entity
    *           The entity that is source of segment data.
    */
   public BTSMetaData (AbstractEntity entity) {
       super(entity);
   }

   /**
    * Return the number of messages in batch.
    * 
    * @return The number of messages in batch.
    */
   public int getMessageCount() {
      return this.messageCount;
   }

   /**
    * Set the number of messages in batch.
    * 
    * @param messageCount
    *           The number of messages in batch.
    */
   public void setMessageCount(int messageCount) {
      this.messageCount = messageCount;
   }
}