/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes

//Framework Classes
import gov.va.med.fw.hl7.segment.BTS;
import gov.va.med.fw.util.builder.BuilderException;

//ESR Classes

/**
 * The class that builds the BTS segment for a message.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class BTSBuilder extends AbstractSegmentBuilder {
    
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -5621335041190913591L;

   public BTSBuilder() {
        super();
    }
    
    /**
     * Method that processes build of BTS segment.
     * 
     * @param metaData
     *           The parameter object used to build a BTS segment.
     * @return BTS Segment
     */
    public Object build( BTSMetaData metaData ) throws BuilderException {
        BTS segment = new BTS();
        
        try {
            segment.setBatchMessageCount(String.valueOf( metaData.getMessageCount()));
        }
        catch (Exception e) {
            throw new BuilderException( "Failed to build BTS Segment due to an exception ", e);
        }
        
        return segment;
    }
}