package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Superclass for ZIC builders. Contains common logic needed by the sub classes 
 * 
 * @author Rajiv Patnaik Created on Jan 5, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public abstract class AbstractZICBuilder extends AbstractSegmentBuilder
{
    private static final long serialVersionUID = -1370346746640850300L;

    protected void discontinueNetWorth(Integer incomeYear, ZIC segment,  FinancialInformation financialInfo) throws BuilderException
    {
    	//VFA: Populated only if Income Year is earlier than 2009.
/*    	if (CommonDateUtils.isIncomeYear2009OrLatter(incomeYear))
    	{
	        //Seq 16
	        segment.setCashAmountInBankAccounts(null);
	        //Seq 18
	        segment.setRealProperty(null);
	        //Seq 19
	        segment.setOtherPropertyAssets(null);
    	} else
    	{*/
            //Seq 16
            segment.setCashAmountInBankAccounts(
                    getAssetAmountAsString(financialInfo, AssetType.CODE_CASH.getName()));
            //Seq 18
            segment.setRealProperty(
                    getAssetAmountAsString(financialInfo, AssetType.CODE_REAL_ESTATE.getName()));
            //Seq 19
            segment.setOtherPropertyAssets(
                    getAssetAmountAsString(financialInfo, AssetType.CODE_OTHER.getName()));

//    	}
    }
    
    protected String getIncomeAsString(FinancialInformation financialInformation,
            String incomeTypeStr) throws BuilderException
    {
        if (financialInformation == null)
            return null;
        
        Income income = null;
        
        try
        {
            IncomeType incomeType = getLookupService().getIncomeTypeByCode(
                    incomeTypeStr);

            income = financialInformation.getIncome(incomeType);

        } catch (ServiceException e)
        {
            throw new BuilderException("Exception looking up IncomeTypeCode "
                    + incomeTypeStr);
        }
        return (income == null ? "" : String.valueOf(income.getAmount()));

    }
    
    protected String getExpensesAsString(FinancialInformation financialInformation,
            String expenseTypeStr) throws BuilderException
    {
        if (financialInformation == null)
            return null;
        
        Expense expense = null;
        try
        {
            ExpenseType expenseType = getLookupService().getExpenseTypeByCode(
                    expenseTypeStr);

            expense = financialInformation.getExpense(expenseType);

        } catch (ServiceException e)
        {
            throw new BuilderException("Exception looking up IncomeTypeCode "
                    + expenseTypeStr);
        }

        return (expense == null ? "" : String.valueOf(expense.getAmount()));

    }

    protected String getAssetAmountAsString(
            FinancialInformation financialInformation, String cashAmountTypeStr)
            throws BuilderException
    {
        if (financialInformation == null)
            return null;
        
        Asset asset = null;
        try
        {
            AssetType assetType = getLookupService().getAssetTypeByCode(
                    cashAmountTypeStr);

            asset = financialInformation.getAsset(assetType);

        } catch (ServiceException e)
        {
            throw new BuilderException("Exception looking up IncomeTypeCode "
                    + cashAmountTypeStr);
        }

        return (asset == null ? "" : String.valueOf(asset.getAmount()));

    }

    /**
     * As per CR 3478, ZIC - sequence 2 - Income year needs to be sent in the YYYY0000 format where the 
     * YYYY is the income year followed by 4 zeros.
     * Vista's API to display the income year requires that the 4 zeros follow the income year        
     * 
     * @param segment
     * @param incomeYear
     */
    protected void setIncomeYear(ZIC segment, Integer incomeYear)
    {
        segment.setIncomeYear(String.valueOf(incomeYear) + "0000");        
    }

}