/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Framework Classes
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;


/**
 * @author Alex Yoon
 * @version 1.0
 */
public abstract class AbstractSegmentBuilder extends AbstractBuilder {
    
    private static final long serialVersionUID = -1370346746640850300L; 
    /* Since some outbound messages convert Booleans to VA001 values and others convert
	 * Boolean values to HL7 0136 values, then we must disgruntingly support both.
	 */
	private Builder booleanBuilderVA001;
	
	private Builder booleanBuilder0136;    
	
	private Builder booleanBuilder0136FromIndicator;	
	
    private Builder genderBuilder;

    private PersonHelperService helperService;

    private LookupService lookupService;
    
	/**
	 * @return Returns the booleanBuilder0136.
	 */
	public Builder getBooleanBuilder0136() {
		return booleanBuilder0136;
	}

	/**
	 * @param booleanBuilder0136 The booleanBuilder0136 to set.
	 */
	public void setBooleanBuilder0136(Builder booleanBuilder0136) {
		this.booleanBuilder0136 = booleanBuilder0136;
	}
	
    /**
     * @return Returns the booleanBuilder0136FromIndicator.
     */
    public Builder getBooleanBuilder0136FromIndicator()
    {
        return booleanBuilder0136FromIndicator;
    }
    /**
     * @param booleanBuilder0136FromIndicator The booleanBuilder0136FromIndicator to set.
     */
    public void setBooleanBuilder0136FromIndicator(
            Builder booleanBuilder0136FromIndicator)
    {
        this.booleanBuilder0136FromIndicator = booleanBuilder0136FromIndicator;
    }

    /**
	 * @return Returns the booleanBuilderVA001.
	 */
	public Builder getBooleanBuilderVA001() {
		return booleanBuilderVA001;
	}

	/**
	 * @param booleanBuilderVA001 The booleanBuilderVA001 to set.
	 */
	public void setBooleanBuilderVA001(Builder booleanBuilderVA001) {
		this.booleanBuilderVA001 = booleanBuilderVA001;
	}
	
	
    /**
     * @return Returns the genderBuilder.
     */
    public Builder getGenderBuilder()
    {
        return genderBuilder;
    }
    /**
     * @param genderBuilder The genderBuilder to set.
     */
    public void setGenderBuilder(Builder genderBuilder)
    {
        this.genderBuilder = genderBuilder;
    }
	/**
     * @return Returns the lookupService.
     */
    public LookupService getLookupService()
    {
        return lookupService;
    }
    /**
     * @param lookupService The lookupService to set.
     */
    public void setLookupService(LookupService lookupService)
    {
        this.lookupService = lookupService;
    }

    /**
     * @return Returns the helperService.
     */
    public PersonHelperService getHelperService()
    {
        return helperService;
    }
    /**
     * @param helperService The helperService to set.
     */
    public void setHelperService(PersonHelperService helperService)
    {
        this.helperService = helperService;
    }

	
	/**
     *  
     */
    protected AbstractSegmentBuilder() {
        super();
    }
    
    /**
     * Method to build a lookup code using passed in builder.
     * 
     * @param builder
     *           Builder object.
     * @param input
     *           AbstractLookup object.
     * @return HL7 lookup code.
     */
    protected String build (Builder builder, AbstractLookup input) throws BuilderException {
        String lookupCode = null;
        
        if (input != null) {
            lookupCode = (String)builder.build(input.getCode());
        }
        
        return lookupCode;
    }

    /**
     * Method to build a Boolean value
     * 
     * @param input
     *           AbstractLookup object.
     * @return HL7 lookup code.
     */
    protected String buildBooleanForVA001(Boolean input) throws BuilderException {
        String lookupCode = null;
        
        if (input != null) {
        		lookupCode = (String)booleanBuilderVA001.build(input.toString());
        }
        
        return lookupCode;
    }

    protected String buildBooleanFor0136(Boolean input) throws BuilderException {
        String lookupCode = null;
        
        if (input != null) {
        		lookupCode = (String)booleanBuilder0136.build(input.toString());
        }
        
        return lookupCode;
    }
    
    protected String buildBooleanFor0136FromIndicator(Indicator input) throws BuilderException {
        String lookupCode = null;
        
        if (input != null) {
        		lookupCode = (String)booleanBuilder0136FromIndicator.build(input.getCode()); 
        }
        
        return lookupCode;
    }    
    
    /**
     * Method to build a lookup code by trimming leading 0.
     * For example, 01 becomes 1.
     * 
     * @param input
     *           AbstractLookup object.
     * @return HL7 lookup code.
     */
    protected String build (AbstractLookup input) throws BuilderException {
        String lookupCode = null;
        
        if (input != null) {
            lookupCode = input.getCode();
        }
        
        return lookupCode;
    }

    protected String build(Number input)
    {
        return input == null ? null : input.toString();
    } 
    
    protected String buildEmptyIfNull(String input)
    {
        return input == null ? StringUtils.EMPTY : input;
    }     
    
    //Default implementation to be overriden by subclasses
    protected void setDefaultValues(Segment segment){}    
}
