/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.batchprocess;

//Java Classes
import gov.va.med.esr.common.batchprocess.StringFileData;
import gov.va.med.esr.messaging.service.retransmission.MessageResender;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;

import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * Class that retransmits outbound messages.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class RetransmissionFromFileProcess extends AbstractDataFileIncrementalProcess  {
    
    private MessagingService messagingService;
    
   
    private MessageResender publisher;
    
    private boolean turnedOn = false;
    
    /**
     * Default constructor.
     */
    public RetransmissionFromFileProcess() {
        super();
    }
    
    
    /**
     * @return Returns the messagingService.
     */
    public MessagingService getMessagingService()
    {
        return messagingService;
    }
    /**
     * @param messagingService The messagingService to set.
     */
    public void setMessagingService(MessagingService messagingService)
    {
        this.messagingService = messagingService;
    }
     
    public MessageResender getPublisher()
    {
        return this.publisher;
    }

    public void setPublisher(MessageResender publisher)
    {
        this.publisher = publisher;
    }
    
    public boolean getTurnedOn()
    {
        return this.turnedOn;
    }

    public void setTurnedOn(boolean turnedOn)
    {
        this.turnedOn = turnedOn;
    }
     
    
    
    public void processDataRecords(
			DataFileProcessExecutionContext context, List beans) {
		
		if (logger.isDebugEnabled())
		{
			int listSize = 0;
			if ( beans != null ) listSize = beans.size();
			
			logger.error("Processing message control number:  " + listSize);
		}
		
		for ( int i=0; beans != null && i< beans.size(); i++)
		{
			StringFileData data = (StringFileData)beans.get(i);

			if ( data == null ) continue;
			
			String messageControlNumber = data.getStringValue();
			
			try
			{
				this.publisher.resend(messageControlNumber);
				context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
			}
			catch(Exception e )
			{
				if (logger.isErrorEnabled())
			           logger.error("Error resending message for messageControlNumber " + messageControlNumber, e);
			            
					context.getProcessStatistics().incrementNumberOfErrorRecords();
				}
				finally
				{
					// Check if we need to update the job result
					if(shouldUpdateJobResult(context))
							updateJobResult(context);
					
					if ( isInterrupted(context))
					{
						break;
					}
				}
		}
    }
    
    
    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull("publisher");
    }

}
