/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.aop;

// Java Classes

// Library Classes
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

// Framework Classes

// Common Classes

// Messaging Classes
import gov.va.med.esr.messaging.util.AbstractExceptionCollectionContextAware;

/**
 * @author Martin Francisco
 */
public class ExceptionCatcher
    extends AbstractExceptionCollectionContextAware
    implements MethodInterceptor
{
    public ExceptionCatcher()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
     */
    public Object invoke(MethodInvocation invocation) throws Throwable
    {
        try
        {
            return invocation.proceed();
        }
        catch(Exception e)
        {
            super.getContext().addException(e);
            return null;
        }
    }
}