#!/bin/sh
# ******************************************************************************
# This script is used to clean up the wehelp directory and unzip the contents of the webhelp zip file

# WEBHELP_HOME - The directory where the webhelp files will reside.
# WEBHELP_ARCHIVE_HOME - The directory which will contain the zip file
#
# ******************************************************************************

#Clean the webhelp directory and unzip the contents of the webhelp zip file

WEBHELP_HOME=/var/www/html/30/webhelp
WEBHELP_ARCHIVE_HOME=/tmp/webhelpArchive30

#Check if webhelp zip filename has been passed as argument
if test $# -ne 1
then
    echo "Invalid option. Please pass webhelp zip file name as argument."
    echo "Usage: $0 <filename>.zip"
    exit 1
else
    rm -rf ${WEBHELP_HOME}/*
    unzip ${WEBHELP_ARCHIVE_HOME}/$1 -d ${WEBHELP_HOME}
    chmod -R 755 ${WEBHELP_HOME}/*
fi
