@ECHO OFF
REM
REM Creates an ESR Weblogic domain in silent mode.
REM Note that the Weblogic bin directory needs to be in the system PATH for
REM this script to run (WL_HOME/weblogic81/common/bin).
REM 
REM This script takes the Weblogic tempalte filename as an optional input.
REM If no template filename is specified, "ESRDomain.jar" will be used
REM as the default.
REM 

REM
REM Set the working home directory to the current directory.
REM 
setlocal
set DOMAIN_NAME=ESRDomain
set PATH=%PATH%;%WL_HOME%\common\bin
set WORK_HOME=%CD%

REM
REM Set the template home.
REM 
set TEMPLATE_HOME=%WORK_HOME%

REM
REM Set the script input filename and log file.
REM
set SCRIPT_INPUT_FILENAME=%DOMAIN_NAME%.txt
set SCRIPT_LOG_FILENAME=%DOMAIN_NAME%.log

REM
REM Set the domain template filename to the first argument or use the default.
REM
set TEMPLATE_FILENAME=%1
if "%1" == "" set TEMPLATE_FILENAME=%DOMAIN_NAME%.jar

REM
REM Ensure the domain template JAR file is in the template home directory.
REM
if NOT EXIST %TEMPLATE_HOME%\%TEMPLATE_FILENAME% goto NO_TEMPLATE_FILE

REM
REM Inform the user that we are creating the domain.
REM
echo Creating Weblogic domain from template '%TEMPLATE_HOME%\%TEMPLATE_FILENAME%' using silent input script: '%SCRIPT_INPUT_FILENAME%'.

REM
REM Delete any previously generated log file
REM
if EXIST %WORK_HOME%\%SCRIPT_LOG_FILENAME% del %WORK_HOME%\%SCRIPT_LOG_FILENAME%

REM
REM Create the script input file.
REM Note that we are creating the input file from within this script so all
REM directories can be absoluate paths in the input file.  This is required
REM for the config script to work properly.
REM
set SOUT=%WORK_HOME%\%SCRIPT_INPUT_FILENAME%
>  %SOUT% ECHO //This is an example of a Configuration Wizard silent script. This example uses the
>> %SOUT% ECHO // Enrollment System Redesign Domain template to show how to open, modify, and write out
>> %SOUT% ECHO // a domain in silent mode. Please note that many values used in this script are subject
>> %SOUT% ECHO // to change based on your WebLogic installation and the template you are using.
>> %SOUT% ECHO //
>> %SOUT% ECHO // Usage:
>> %SOUT% ECHO //      ^<Windows^> = config.cmd -mode=silent -silent_script=^<silent script^>
>> %SOUT% ECHO //      ^<Unix^>    = ./config.sh -mode=silent -silent_script=^<silent script^>
>> %SOUT% ECHO //
>> %SOUT% ECHO // Where:
>> %SOUT% ECHO //      ^<silent script^> should be the full path to the silent script.
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO. 
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO //Read in a domain template.
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO. 
>> %SOUT% ECHO read template from
>> %SOUT% ECHO     "%TEMPLATE_HOME%\%TEMPLATE_FILENAME%";
>> %SOUT% ECHO. 
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO //Write out the domain.
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO set OverwriteDomain "true";
>> %SOUT% ECHO write domain to "%BEA_HOME%\user_projects\domains\%DOMAIN_NAME%";
>> %SOUT% ECHO. 
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO //Close domain template to indicate completion of work.
>> %SOUT% ECHO /////////////////////////////////////////////////////////////////////////////////////////
>> %SOUT% ECHO close template;

REM
REM Execute the Weblogic configuration script to create the domain.
REM The config script will run the Weblogic configuration wizard in silent mode.
REM Note that the config.sh script comes with Weblogic and should be in the
REM system PATH.
REM
config.cmd -mode=silent -silent_script=%WORK_HOME%\%SCRIPT_INPUT_FILENAME% -log=%WORK_HOME%\%SCRIPT_LOG_FILENAME%
endlocal
goto END

:NO_TEMPLATE_FILE
echo The ESR domain template file '%TEMPLATE_FILENAME%' could not be found in the directory: '%TEMPLATE_HOME%'.
goto END

REM
REM End of the batch file
REM
:END