#!/bin/sh
# *************************************************************************
# This script is used to set up your environment for development with 
# WebLogic Server. It simply calls the commEnv.sh script under 
# @WL_HOME/common/bin.  Add domain specific configuration in this script below.
# *************************************************************************

# set up WL_HOME, the root directory of your WebLogic installation
WL_HOME="@WL_HOME"

# set up common environment
# Set Production Mode.  When this is set to true, the server starts up in
# production mode.  When set to false, the server starts up in development
# mode.  If it is not set, it will default to false.
PRODUCTION_MODE="@PRODUCTION_MODE"

# Set JAVA_VENDOR to java virtual machine you want to run on server side.
JAVA_VENDOR="@JAVA_VENDOR"

# Set JAVA_HOME to java virtual machine you want to run on server side.
JAVA_HOME="@JAVA_HOME"

. "${WL_HOME}/common/bin/commEnv.sh"

CLASSPATH="${WEBLOGIC_CLASSPATH}${CLASSPATHSEP}${POINTBASE_CLASSPATH}${CLASSPATHSEP}${JAVA_HOME}/jre/lib/rt.jar${CLASSPATHSEP}${WL_HOME}/server/lib/webservices.jar"
export CLASSPATH
