#!/bin/sh
# *************************************************************************
# This script is used to deploy an esr.ear application
# Usage: undeploy
# *************************************************************************

# Default values
CLUSTER1_NAME="ESRCluster1"
CLUSTER2_NAME="ESRCluster2"
CLUSTER3_NAME="ESRCluster3"

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

# Check for user name and passowrd
if [ "$1" != "" ] ; then
   UIDPWD="-username $1"
   shift
fi

if [ "$1" != "" ] ; then
   UIDPWD="${UIDPWD} -password $1"
   shift
fi

# Check for server name
if [ "$1" != "" ] ; then
   CLUSTER1_NAME="$1"
   shift
fi

# Check for server name
if [ "$1" != "" ] ; then
   CLUSTER2_NAME="$1"
   shift
fi

# Check for server name
if [ "$1" != "" ] ; then
   CLUSTER3_NAME="$1"
   shift
fi

# Check for Admin URL
if [ "$1" != "" ] ; then
   ADMIN_URL="$1"
   shift
fi

echo "Undeploying ${APP_NAME} from ${CLUSTER1_NAME} ..."
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Deployer -adminurl ${ADMIN_URL} ${UIDPWD} -name ${APP_NAME} -targets ${CLUSTER1_NAME} -stop 2>&1
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Deployer -adminurl ${ADMIN_URL} ${UIDPWD} -name ${APP_NAME} -targets ${CLUSTER1_NAME} -undeploy 2>&1
echo "Undeploying ${APP_NAME} from ${CLUSTER1_NAME} is completed"

echo "Undeploying ${APP_NAME} from ${CLUSTER2_NAME} ..."
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Deployer -adminurl ${ADMIN_URL} ${UIDPWD} -name ${APP_NAME} -targets ${CLUSTER2_NAME} -stop 2>&1
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Deployer -adminurl ${ADMIN_URL} ${UIDPWD} -name ${APP_NAME} -targets ${CLUSTER2_NAME} -undeploy 2>&1
echo "Undeploying ${APP_NAME} from ${CLUSTER2_NAME} is completed"

echo "Undeploying ${APP_NAME} from ${CLUSTER3_NAME} ..."
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Deployer -adminurl ${ADMIN_URL} ${UIDPWD} -name ${APP_NAME} -targets ${CLUSTER3_NAME} -stop 2>&1
${JAVA_HOME}/bin/java ${JAVA_VM} ${MEM_ARGS} -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Deployer -adminurl ${ADMIN_URL} ${UIDPWD} -name ${APP_NAME} -targets ${CLUSTER3_NAME} -undeploy 2>&1
echo "Undeploying ${APP_NAME} from ${CLUSTER3_NAME} is completed"

echo "Done"
