#!/bin/sh
# *************************************************************************
# This script is used to store weblogic admin user credentials
# Usage: storeCredentials [username] [password] [admin-url]
# *************************************************************************

# Default values
UIDPWD="-username weblogic -password weblogic"

# Set common environment variables such as WEBLOGIC_CLASSPATH
if [ "$DOMAIN_HOME" == "" ] ; then
   # If the Domain_Home is not found, assume that the setEnv.sh is in the current directory
    if [ -x ./setEnv.sh ] ; then
        . ./setEnv.sh
    else
      echo ./setEnv.sh is not executable or not found.
      exit 1
    fi
else
    if [ -x ${DOMAIN_HOME}/setEnv.sh ] ; then
        . ${DOMAIN_HOME}/setEnv.sh
    else
      echo ${DOMAIN_HOME}/setEnv.sh is not executable or not found.
      exit 1
    fi
fi

# Check for user name and passowrd
if [ "$1" != "" ] ; then
   UIDPWD="-username $1"
   shift
fi

if [ "$1" != "" ] ; then
   UIDPWD="${UIDPWD} -password $1"
   shift
fi

# Check for Admin URL
if [ "$1" != "" ] ; then
   ADMIN_URL="$1"
   shift
fi

echo "Storing credentials ..."
${JAVA_HOME}/bin/java -cp ${WEBLOGIC_CLASSPATH} ${JAVA_OPTIONS} weblogic.Admin -adminurl ${ADMIN_URL} ${UIDPWD} STOREUSERCONFIG 2>&1
echo "Done"
